
<?php
session_start();
require_once '../db_connect.php';

if (!isset($_SESSION['admin_logged_in'])) header("Location: index.php");

// Approve Logic
if (isset($_GET['approve'])) {
    $dep_id = $_GET['approve'];
    
    // ডিপোজিট ইনফো বের করা
    $qry = $conn->query("SELECT * FROM deposits WHERE id='$dep_id' AND status='pending'");
    if ($qry->num_rows > 0) {
        $data = $qry->fetch_assoc();
        $uid = $data['user_id'];
        $amount = $data['amount'];

        // ইউজারের ব্যালেন্স বাড়ানো
        $conn->query("UPDATE users SET balance = balance + $amount WHERE id='$uid'");
        // ডিপোজিট স্ট্যাটাস আপডেট করা
        $conn->query("UPDATE deposits SET status='approved' WHERE id='$dep_id'");
        
        echo "<script>alert('Deposit Approved & Balance Added!'); window.location='deposits.php';</script>";
    }
}

// Reject Logic
if (isset($_GET['reject'])) {
    $dep_id = $_GET['reject'];
    $conn->query("UPDATE deposits SET status='rejected' WHERE id='$dep_id'");
    header("Location: deposits.php");
}

$deposits = $conn->query("SELECT deposits.*, users.phone, users.u_id FROM deposits JOIN users ON deposits.user_id = users.id ORDER BY deposits.id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Deposits</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
    <style>
        table { width: 100%; border-collapse: collapse; margin-top: 20px; background: #1E2129; }
        th, td { padding: 10px; text-align: left; border-bottom: 1px solid #333; color: #ddd; }
        th { background: #000; color: #F5C300; }
        .badge { padding: 3px 8px; border-radius: 4px; font-size: 11px; }
        .pending { background: #ff9800; color: #000; }
        .approved { background: #28a745; color: #fff; }
        .rejected { background: #dc3545; color: #fff; }
        .btn { padding: 5px 10px; border-radius: 3px; text-decoration: none; color: #fff; font-size: 12px; margin-right: 5px; }
        .btn-approve { background: #28a745; }
        .btn-reject { background: #dc3545; }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="logo">BOT CLUB ADMIN</div>
        <ul>
            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="users.php"><i class="fas fa-users"></i> Users</a></li>
            <li><a href="deposits.php" class="active"><i class="fas fa-money-bill-wave"></i> Deposits</a></li>
            <li><a href="withdrawals.php"><i class="fas fa-hand-holding-usd"></i> Withdrawals</a></li>
        </ul>
    </div>

    <div class="main-content">
        <div class="header"><h2>Deposit Requests</h2></div>
        <table>
            <thead>
                <tr>
                    <th>User ID</th>
                    <th>Phone</th>
                    <th>Method</th>
                    <th>TrxID</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while($row = $deposits->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $row['u_id']; ?></td>
                    <td><?php echo $row['phone']; ?></td>
                    <td><?php echo $row['method']; ?></td>
                    <td><?php echo $row['transaction_id']; ?></td>
                    <td style="color:#F5C300; font-weight:bold;">৳ <?php echo $row['amount']; ?></td>
                    <td><span class="badge <?php echo $row['status']; ?>"><?php echo ucfirst($row['status']); ?></span></td>
                    <td>
                        <?php if($row['status'] == 'pending'): ?>
                            <a href="deposits.php?approve=<?php echo $row['id']; ?>" class="btn btn-approve" onclick="return confirm('Approve this deposit?')">Approve</a>
                            <a href="deposits.php?reject=<?php echo $row['id']; ?>" class="btn btn-reject" onclick="return confirm('Reject this deposit?')">Reject</a>
                        <?php else: ?>
                            --
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
